cc  FORTRAN77 code: Application, Section 11.8
cc  File: mtarsch-2015.for
cc  Coded by Ruey S. Tsay with minor modifications by JDG
cc
cc  This program is intended for nonlinear time series analysis.
cc  It searches for the threshold values (regime = 3, at most) of a
cc  multivariate TAR model. It uses Minimum AIC criterion.
cc
cc  Created on May 20, 1997 to analyze intraday data sets.
cc
cc  The program estimates a threshold-regression model: threshold variable
cc  and ranges of the thresholds must be given.
cc  input: dat(.,.) is the data matrix
cc         locy: the column number in dat(.,.) that gives the dependent var.
cc         locthr: column in which threshold variable is stored in dat(.,.)
cc         locx: columns where independent variables are located in dat(.,.).
cc         iorx: order of each independent variables
cc         ixlag: lags of each independent variables
cc         p: order of the dependent variable
cc         nx: number of exogeneous variables.
cc         (nst, nend): data span used in the program
cc  
cc  Example:
cc    nob, nvar, n_y, n_x, delay, nregime, loc_thr: 1095 4 2 2 0 2 4
cc    Data_file Name: ice4col.dat
cc    input data span (1 = yes): 0
cc    loc_y: 1 2
cc    loc_x: 3 4
cc    AR order: 15
cc    #(lags) of the x-variables: 3 2
cc    input detailed lags of exog. vars? (1=y): 1
cc    lags of  1-th exo. var (L to H): 1 2 3
cc    lags of  2-th exo. var (L to H): 0 1
cc    input LOW. & UPP. bnd for threshold  1: -3 3
cc    Input the numbers of pts for thresholds: 300
cc    Thresholds:    -0.408638
cc    Overall minimum AIC 0.16950E+05
cc    index of thr-values:   130    1
cc    AIC in fort.15, 1st thr in fort.31 & 2nd in fort.32
cccccccccccccc Current setting
c    max-variables = 5
cc   max-obs = 10000
c
       parameter(maxn=10000,md=50,mk=5)
       real*8 xpx(md,md),xpy(md,mk),xpxinv(md,md) 
       real*8 phi(md,mk),y(maxn,5),dat(maxn,6), thr(10)
       real*8 resi(maxn,mk), tem, chk, x(maxn,md)
       real*8 aic, dlog, wk(md,md)
       real*8 thrva(500,2), bnd(2,2), aicmin, gthr(10)
c
       integer nob, p, ip, lagth, nreg, npts(10)
       integer locy(5), locthr, nx, ny, locx(5), nvar, i, j 
       integer iorx(5), ist, ia, ii, jj, it, i3, i4
       integer icnt, nst, nend, idx, i1, i2, npos(2)
       integer ixlag(10,5)
c-------- npos(.) stores the number of candidates for each threshold.
c
       character nfile*30
c
       iout = 15
c
c---------- nob = # of observations; p = ar-order
c
       write(6,1)
    1  format(1x,'nob, nvar, n_y, n_x, delay, nregime, loc_thr: ',$)
       read(5,*)nob, nvar, ny, nx, lagth, nreg, locthr
       if(nob .le. 0)stop
       if(nob .gt. maxn)nob = maxn
       if(nvar .le. 0)nvar = 1
       if(nreg.le.1)stop
       if(nreg.gt.3)then
        print*,'too many regimes. Reset to 3'
        nreg = 3
       endif
       if((ny+nx).gt.nvar)then
        print*,'Number of variables fails to match'
        stop
       endif
       if(nvar .gt. 5)then
        print*,'too many variables! (the maximum is 5)'
        stop
       endif
       if(lagth.lt.0)lagth = 0
       if(locthr.le.0)locthr = 1
c
       write(6,2)
    2  format(1x,'Data_file Name: ',$)
       read(5,3)nfile
    3  format(a30)
       open(unit=21,file=nfile,status='old')
       do 4 i = 1, nob
 4        read(21,*)(dat(i,j),j=1,nvar)
       close(21)
c
       write(6,401)
 401   format(1x,'input data span (1 = yes): ',$)
       read(5,*) ii
       if(ii.eq.1)then
        write(6,402)
        read(5,*) nst, nend
        if(nend.gt.nob) nend=nob
        if(nst.lt.1) nst = 1
        nob = nend-nst+1
        if(nst.eq.1)go to 415
        do 410 it=1, nob
         do 408 i=1, nvar
 408        dat(it,i) = dat(it-1+nst,i)
 410        continue
       endif
 402    format(1x,'data span (nst, nend): ',$)
 415    continue
c
       write(6,5)
 5     format(1x,'loc_y: ',$)
       read(5,*) (locy(i),i=1,ny)
c
       if(nx.gt.0)then
        write(6,7)
        read(5,*)(locx(i),i=1,nx)
       endif
 7      format(1x,'loc_x: ',$)
       write(6,8)
 8     format(1x,'AR order: ',$)
       read(5,*) p
       if(nx.gt.0)then
        write(6,9)
        read(5,*)(iorx(i),i=1,nx)
        do 44 i=1, nx
         do 42 j=1, iorx(i)
 42         ixlag(j,i) = j
 44         continue
        write(6,56)
        read(5,*) it
        if(it.eq.1)then
         do 54 i=1, nx
          write(6,57) i
          read(5,*)(ixlag(j,i),j=1,iorx(i))
          do 53 j=1, iorx(i)
           if(ixlag(j,i).lt.0)then
              print*,'negative order not allowed'
              stop
             endif
 53        continue
 54       continue
        endif
       endif
 9      format(1x,'#(lags) of the x-variables: ',$)
 56     format(1x,'input detailed lags of exog. vars? (1=y): ',$)
 57     format(1x,'lags of',i3,'-th exo. var (L to H): ',$)
c      
c--------- input thresholds
       do 600 i=1, nreg-1
       write(6,11) i
       read(5,*)(bnd(i,j),j=1,2)
 600   continue
   11  format(1x,'input LOW. & UPP. bnd for threshold',i3,': ',$)
c
       thr(1) = -9.9d15
       i = nreg+1
       thr(i) = 9.9d15
c
       write(6,610)
 610   format(1x,'Input the numbers of pts for thresholds: ',$)
       read(5,*)(npos(i),i=1,nreg-1)
       do 612 i=1, nreg-1
          if(npos(i).gt.500)then
           print*,'thr-npt exceeds 500, reset = 500'
           npos(i) = 500
          endif
 612      if(npos(i).le.0)npos(i) = 1
c
       do 650 i=1, nreg-1
        tem = (bnd(i,2)-bnd(i,1))/dfloat(npos(i)+1)
        do 645 j=1, npos(i)
 645       thrva(j,i) = bnd(i,1)+tem*dfloat(j)
 650       continue
c
      ist = p
      if(nx.gt.0)then
       do 17 i=1, nx
 17       if(ist.lt.ixlag(iorx(i),i))ist=ixlag(iorx(i),i)
      endif
      ist = max0(ist, lagth)+1
c
c------- including a constant term (ip = dimension of x-matrix)
       ip = 1+p*ny  
       if(nx.gt.0)then
        do 18 i=1, nx
 18        ip = ip + iorx(i)
       endif
       if(ip.gt.md)then
        print*,'dimension exceeds program specification'
        stop
       endif
c
      aicmin = 9.9d10
c--------------------------- prepare for the case of nreg = 2.
      if(nreg.eq.2)then
       npos(2) = 1
       thrva(1,2) = thr(3)
      endif
c----------------------------- 3 regimes are the maximum
      do 5000 i1 = 1, npos(1)
       thr(2) = thrva(i1,1)
       do 4500 i2 = 1, npos(2)
        thr(3) = thrva(i2,2)
        aic = 0.0d0
c
       do 3000  ia = 1, nreg
        icnt = 0
c
        do 100 it = ist, nob
         chk = dat(it-lagth,locthr)  
         if(chk.lt.thr(ia))go to 100
         if(chk.ge.thr(ia+1))go to 100
c------------- the observation is in the ia-th regime
         icnt = icnt+1
         do 20 i=1, ny
 20         y(icnt,i) = dat(it,locy(i))
         x(icnt,1) = 1.0d0
         idx = 1
         if(p.gt.0)then
          do 32 ii=1, ny 
           do 30 i=1, p
             idx=idx+1
 30          x(icnt,idx) = dat(it-i,locy(ii))
 32        continue
         endif
c
        if(nx.gt.0)then
         do 50 ii=1, nx
          if(iorx(ii).gt.0)then
           do 40 jj=1, iorx(ii)
              idx=idx+1
 40           x(icnt,idx)=dat(it-ixlag(jj,ii),locx(ii))
          endif
 50      continue
        endif
c
 100    continue
c
        npts(ia) = icnt
        if(icnt.le.ip)then
         print*,'insufficient data points in the', ia,'-th regime'
         go to 3000
        endif
c
       if(idx.ne.ip)then
        print*,'dimension error'
        stop
       endif
       call regr(y,x,maxn,md,ny,ip,icnt,xpx,xpxinv,xpy,phi)
c
c----------residuals
       do 120 it=1, icnt
        do 115 i=1, ny 
         tem = 0.0d0
         do 110 ii=1, ip
 110      tem = tem + phi(ii,i)*x(it,ii)
       resi(it,i) = y(it,i)-tem
 115   continue
 120   continue
c----------------- Residual covariance matrix (MLE-type only for AIC).
       do 200 i=1, ny
        do 190 j=1, i
         tem = 0.0d0
         do 180 it=1, icnt
 180        tem=tem+resi(it,i)*resi(it,j)
        xpx(j,i) = tem/dfloat(icnt)
 190    xpx(i,j) = tem
 200    continue
c
       call detmtx(xpx,wk,md,ny,tem)
**
       tem = dlog(tem)*dfloat(icnt)
       aic = aic + tem + 2.0d0*dfloat(ip*ny)
c
c--------------- return for another regime
 3000  continue
c
       write(iout,3004) aic
       if(aicmin .ge. aic)then
        aicmin = aic
        do 500 j=1, nreg-1
 500       gthr(j) = thr(j+1)
       i3 = i1
       i4 = i2
       endif
c
 4500  continue
 5000  continue
c
       write(6,3002)(gthr(i),i=1,nreg-1)
 3002  format(1x,'Thresholds: ',5f12.6)
       write(6,3003) aicmin
 3003  format(1x,'Overall minimum AIC',e12.5)
       write(6,3007) i3, i4
 3004  format(1x,f14.6)
       write(31,3005)(thrva(j,1),j=1,npos(1))
       if(nreg.eq.3) write(32,3005)(thrva(j,2),j=1,npos(2))
 3005  format(1x,f14.7)
 3007  format(1x,'index of thr-values: ',2i5)
c
       print*,'AIC in fort.15, 1st thr in fort.31 & 2nd in fort.32'
c
       stop
       end
ccccccccccccccccccccccccccccccccccccccccccc
      subroutine mtinv(a, da, kcomp,idim)
c**** 
      integer i,j,kcomp,idim,ii
      real*8 a(kcomp,kcomp), da(kcomp,kcomp)
      real*8 dpivot, pivot, deta, t

      deta = 1.0d0
c**** 
      if (idim .eq. 1) goto 600
      do 100 i = 1, idim
      do 100 j = 1, idim
  100 da(i,j) = a(i,j)
  120 do 500 i = 1, idim
      pivot = da(i,i)
c**** 
c**** DIVIDE PIVOT ROW BY PIVOT ELEMENT.
c**** 
      deta = deta * pivot
      da(i,i) = 1.0d0
      dpivot = pivot + 1.0d-25
      dpivot = da(i,i) / dpivot
      pivot = dpivot
      do 200 j = 1, idim
c**** 
c**** REDUCE NON-PIVOT ROWS
c****
  200 da(i,j) = da(i,j) * pivot
  210 do 500 ii = 1, idim
      if (ii .eq. i) goto 500
      t = da(ii,i)
      da(ii,i) = 0.0d0
      do 300 j = 1, idim
c****
  300 da(ii,j) = da(ii,j) - (da(i,j) * t)
  500 continue
      return 
  600 da(1,1) = deta / a(1,1)
      return 
      end
c****
c**** END OF 'MTINV'
c**** 
c*****************************************
       subroutine regr(y,x,maxn,md,ny,ip,n,xpx,xpxinv,xpy,phi)
c
       real*8 y(maxn,*),x(maxn,md),xpx(md,md),xpy(md,*),phi(md,*)
       real*8 xpxinv(md,md), tem
c
       integer ip,n,i,j,it,ii,ny
c
       do 100 i=1, ip
        do 90 j = 1, i
         tem = 0.0d0
         do 80 it = 1, n
 80         tem=tem+x(it,i)*x(it,j)
         xpx(i,j) = tem
 90      xpx(j,i) = tem
 100     continue
c
       do 120 ii=1, ny
        do 110 i=1, ip
         tem = 0.0d0
         do 105 it=1, n
 105       tem=tem+x(it,i)*y(it,ii)
 110       xpy(i,ii) = tem
 120       continue
c
        call mtinv(xpx,xpxinv,md,ip)
c
       do 160 ii=1, ny
        do 150 i=1, ip
         tem = 0.0d0
         do 140 j = 1, ip
 140        tem=tem+xpxinv(i,j)*xpy(j,ii)
 150        phi(i,ii) = tem
 160        continue
c
        return
        end
ccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c*****************************************
       subroutine detmtx(a,wk,mx,k,det)
c
c---- This program computes the determinant of a covariance matrix.
c     It assumes that the variance of each variable is not close to zero.
c     The program transforms the mtx into an upper triangular one.
c
       real*8 a(mx,mx), det, tem, wk(mx,mx), crit
       integer mx, k, i, j, km1
c--------- wk(.,.) is a working area.
c
       if(k.eq.1)then
        det = a(1,1)
        return
       endif
c
       km1 = k-1
       crit = 1.0d-15
c
       do 10 i=1, k
        do 10 j=1, k
 10        wk(i,j) = a(i,j)
c
       do 50 i=1, km1
        if(dabs(a(i,i)).le.crit)then 
         det = 0.0d0
         return
        endif
        tem = wk(i+1,i)/a(i,i)
        do 40 j=i+1, k
 40       wk(i+1,j) = wk(i+1,j)-wk(i,j)*tem
 50      continue
c
       det = 1.0d0
       do 60 i=1, k
 60       det = det*wk(i,i)
c
cc       print*,'det = ', det
c
       return
       end
ccccccccccccccccccccccccccccccccccccccccccccccccccc
